//---
// RayMarching utils
//---
#include "WorldConstants.hlsli"
//To do How to inject ?

// Distance Operators
//float opRep( float3 p, float3 c )
//{
//    //see http://stackoverflow.com/questions/7610631/glsl-mod-vs-hlsl-fmod
//    float3 q = fmod(abs(p),c) - 0.5*c;
//    return obj1(q);
//}

float _union(float a, float b)
{
    return min(a, b);
}

float intersect(float a, float b)
{
    return max(a, b);
}

float difference(float a, float b)
{
    return max(a, -b);
}


// domain operator
interface Primitive
{
  float Compute(float3 p);
};

// intensity provider
interface IntensityProvider
{
  float IntensityAt(float3 p);
};

// cam animator
interface CamAnimator
{
  float2x3 GetRays();
};

// led domain
interface LedDomain
{
  bool IsOutside(float3 pos);
};

float3 opTransform( float3 p, float4x4 m, Primitive primitive)
{
    float3 q = mul(float4(p,1),m).xyz;
    return primitive.Compute(q);
}

float3 opScale( float3 p, float s, Primitive primitive)
{
    return primitive.Compute(p*s)/s;
}

float3 opTranslate( float3 p, float3 translate, Primitive primitive)
{
    return primitive.Compute(p+translate);
}




// Signal
float pulse(float x, float inf, float sup)
{
    return step(inf, x) - step(sup, x); 
}

// Primitives
float plane(float3 p, float3 planeN, float3 planePos)
{
    return dot(p - planePos, planeN);
}

float udRoundBox( float3 p, float3 bb, float r )
{
  float3 di = max(abs(p)-bb,0.0);
  return length(di) - r;
}

float sdBox( float3 p, float3 b )
{
  float3 d = abs(p) - b;
  return min(max(d.x,max(d.y,d.z)),0.0) + length(max(d,0.0));
}

float sdCylinder( float3 p, float3 c )
{
  return length(p.xz-c.xy) - c.z; // ???
}

float yCylinder(float3 p, float r)
{
    return length(p.xz) - r;
}

float yCutCylinder(float3 p, float r, float h)
{
    float d = length(p.xz) - r;
    d = difference(d, plane(p, -WorldAxis.Y, h * WorldAxis.Y));
    d = difference(d, plane(p,  WorldAxis.Y, WorldPoints.O));
    return d;
}


float yTorus( float3 p, float radius, float section )
{
    float tmp = length(p.xz) - radius;
    return length(float2(tmp, p.y)) - section;
}



//float yProfile(float3 p, float r, float h)

// sphere centered at o(0,0,0)
float sdSphere( float3 p, float r )
{
  return length(p) - r;
}


float3 fmod2(float3 x, float3 y)
{
    // Description of fmod(x,y) from HLSL documentation :
    // "The floating-point remainder is calculated such that x = i * y + f,
    // where i is an integer, f has the same sign as x, and the absolute value of f is less than the absolute value of y."
    //   We want f to be positive -> return y + f if x is negative
    return fmod(x,y) + y * saturate(-sign(x));
}

float3 fmod2(float x, float y)
{
    // Description of fmod(x,y) from HLSL documentation :
    // "The floating-point remainder is calculated such that x = i * y + f,
    // where i is an integer, f has the same sign as x, and the absolute value of f is less than the absolute value of y."
    //   We want f to be positive -> return y + f if x is negative
    return fmod(x,y) + y * saturate(-sign(x));
}


// Warping around the center of the world
float3 warp( float3 pos, float3 warpExtent )
{
    float3 warpExtentSafe = max(warpExtent, (float3) 0.001 ); // avoid div by 0
    float3 fullWarp = fmod2( pos, warpExtentSafe );
    float3 warpInterest = max( (float3)0, sign(warpExtent) ); // 1 where warpExtent is positive
    return lerp( pos, fullWarp, warpInterest );               // Ignore components where warpExtent <= 0
}

// Warping around a box
float3 warpBox( float3 pos, float3 boxCenter, float3 boxSize )
{
    float3 boxOrigin = boxCenter - boxSize;
    return boxOrigin + warp( pos - boxOrigin, boxSize * 2 );
}

// extract 4 values between 0 and 1 encoded in a uint32
float4 Unpack( uint packed )
{
    return float4( (float) ((packed >> 0 ) & 255) / 255.f,
                   (float) ((packed >> 8 ) & 255) / 255.f,
                   (float) ((packed >> 16) & 255) / 255.f,
                   (float) ((packed >> 24) & 255) / 255.f );
}

// Make a 32 bit index out of 3 separate integer coords
// sizeBits the size of encoding (not more than 10 because 32 / 3)
uint MakeIndex( uint3 coords, uint sizeBits )
{
    return (coords[2] << (sizeBits * 2) + coords[1] << (sizeBits * 1) + coords[0]);
}

uint3 SplitIndex( uint index, uint sizeBits )
{
    uint mask = (1 << sizeBits) - 1;
    return int3( index & mask,
                 (index >> sizeBits) & mask,
                 (index >> sizeBits * 2) & mask );
}

